<?php
/**
 * Payment Pending Template
 * 
 * This template can be overridden by copying it to:
 * yourtheme/secondlife-payments/payment-pending.php
 * 
 * Available variables:
 * @var WC_Order $order - The WooCommerce order
 * @var object $transaction - Transaction data from database
 * @var string $slurl - SLURL to payment box location
 * @var int $remaining_time - Seconds remaining until timeout
 */

defined('ABSPATH') || exit;
?>

<div class="sl-payment-pending" data-transaction-id="<?php echo esc_attr($transaction->transaction_id); ?>">
    
    <div class="sl-payment-status">
        <div class="sl-spinner"></div>
        <h3><?php esc_html_e('Awaiting Payment in Second Life', 'secondlife-payments'); ?></h3>
        <p class="sl-status-message"><?php esc_html_e('Please complete your payment using Second Life', 'secondlife-payments'); ?></p>
    </div>
    
    <div class="sl-payment-details">
        <table>
            <tbody>
                <tr>
                    <th><?php esc_html_e('Order Number:', 'secondlife-payments'); ?></th>
                    <td>#<?php echo esc_html($order->get_order_number()); ?></td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Amount to Pay:', 'secondlife-payments'); ?></th>
                    <td><strong class="sl-amount">L$<?php echo number_format($transaction->amount); ?></strong></td>
                </tr>
                <tr>
                    <th><?php esc_html_e('Pay From Avatar:', 'secondlife-payments'); ?></th>
                    <td><strong><?php echo esc_html($transaction->buyer_sl_name); ?></strong></td>
                </tr>
                <?php if (!empty($transaction->region)): ?>
                <tr>
                    <th><?php esc_html_e('Box Location:', 'secondlife-payments'); ?></th>
                    <td><?php echo esc_html($transaction->region); ?></td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <div class="sl-payment-instructions">
        <h4><?php esc_html_e('How to Complete Your Payment:', 'secondlife-payments'); ?></h4>
        
        <ol>
            <li>
                <strong><?php esc_html_e('Open Second Life', 'secondlife-payments'); ?></strong>
                <p><?php esc_html_e('Log in with the avatar name shown above', 'secondlife-payments'); ?></p>
            </li>
            
            <?php if (!empty($slurl)): ?>
            <li>
                <strong><?php esc_html_e('Teleport to Payment Box', 'secondlife-payments'); ?></strong>
                <p><?php esc_html_e('Click the link below to teleport directly:', 'secondlife-payments'); ?></p>
                <a href="<?php echo esc_url($slurl); ?>" class="sl-slurl-link" target="_blank" rel="noopener">
                    <span class="sl-slurl-icon">📍</span>
                    <?php echo esc_html($slurl); ?>
                </a>
            </li>
            <?php else: ?>
            <li>
                <strong><?php esc_html_e('Find Our Payment Box', 'secondlife-payments'); ?></strong>
                <p><?php esc_html_e('Navigate to our in-world location', 'secondlife-payments'); ?></p>
            </li>
            <?php endif; ?>
            
            <li>
                <strong><?php esc_html_e('Make the Payment', 'secondlife-payments'); ?></strong>
                <p><?php esc_html_e('Right-click the payment box and select "Pay"', 'secondlife-payments'); ?></p>
            </li>
            
            <li>
                <strong><?php esc_html_e('Enter the Exact Amount', 'secondlife-payments'); ?></strong>
                <p>
                    <?php 
                    printf(
                        esc_html__('Enter L$%s and click "Pay"', 'secondlife-payments'),
                        number_format($transaction->amount)
                    ); 
                    ?>
                </p>
            </li>
        </ol>
        
        <div class="sl-payment-warning">
            <strong>⚠️ <?php esc_html_e('Important:', 'secondlife-payments'); ?></strong>
            <?php esc_html_e('You must pay from the exact avatar name shown above. Payments from other avatars will be automatically refunded.', 'secondlife-payments'); ?>
        </div>
    </div>
    
    <div class="sl-payment-timeout">
        <p>
            <span class="sl-timeout-label"><?php esc_html_e('Time remaining to complete payment:', 'secondlife-payments'); ?></span>
            <span class="sl-countdown" data-expires="<?php echo esc_attr(strtotime($transaction->expires_at)); ?>">
                <?php echo esc_html(gmdate('i:s', $remaining_time)); ?>
            </span>
        </p>
    </div>
    
    <div class="sl-payment-help">
        <details>
            <summary><?php esc_html_e('Need help?', 'secondlife-payments'); ?></summary>
            <div class="sl-help-content">
                <h5><?php esc_html_e("Don't have Second Life?", 'secondlife-payments'); ?></h5>
                <p>
                    <?php esc_html_e('Second Life is a free virtual world. You can create an account at', 'secondlife-payments'); ?>
                    <a href="https://secondlife.com" target="_blank" rel="noopener">secondlife.com</a>
                </p>
                
                <h5><?php esc_html_e("Don't have Linden Dollars?", 'secondlife-payments'); ?></h5>
                <p>
                    <?php esc_html_e('You can purchase L$ directly through Second Life or from authorized exchanges.', 'secondlife-payments'); ?>
                </p>
                
                <h5><?php esc_html_e('Having trouble paying?', 'secondlife-payments'); ?></h5>
                <p>
                    <?php 
                    printf(
                        esc_html__('Please contact us at %s for assistance.', 'secondlife-payments'),
                        '<a href="mailto:' . antispambot(get_option('admin_email')) . '">' . antispambot(get_option('admin_email')) . '</a>'
                    ); 
                    ?>
                </p>
            </div>
        </details>
    </div>
    
</div>

<?php
// Note: Styles are loaded from sl-checkout.css
// JavaScript polling is handled by sl-checkout.js
?>
